path "gfx_2d";

bmap tut_back_pcx = "tut_back.pcx";
bmap mousemap = "tut_mousemap.pcx";

bmap tut1_input_pcx = "tut1_input.pcx";
bmap tut1_button_pcx = "tut1_button.pcx";
bmap tut1_over_pcx = "tut1_over.pcx";
bmap tut1_choice_pcx = "tut1_choice.pcx";
bmap tut1_selector_pcx = "tut1_selector.pcx";
bmap tut1_sel_dummy_tga = "tut1_sel_dummy.tga";

string main_wmb = "menu.wmb";
string choosen_str[10];
string choice_str = "Smith\nWesson\nHeckler\nKoch\nColt";

font menu_font = "Arial", 1, 18;

PANEL back_pan
{
	bmap = tut_back.pcx;
	layer = 1;
	flags = visible;
}

PANEL input_pan
{
	bmap = tut1_input_pcx;
	pos_x = 20;
	pos_y = 20;
	layer = 2;
	flags = visible;
}

PANEL button_pan
{
	bmap = tut1_button_pcx;
	pos_x = 230;
	pos_y = 20;
	button = 0, 0, tut1_button_pcx, NULL, tut1_over_pcx, swap_choice_panel, NULL, NULL;
	layer = 2;
	flags = visible;
}

PANEL choice_pan
{
	bmap = tut1_choice_pcx;
	button = 0, 0, tut1_sel_dummy_tga, NULL, tut1_selector_pcx, tut1_select_item, NULL, NULL;
	button = 0, 18, tut1_sel_dummy_tga, NULL, tut1_selector_pcx, tut1_select_item, NULL, NULL;
	button = 0, 36, tut1_sel_dummy_tga, NULL, tut1_selector_pcx, tut1_select_item, NULL, NULL;
	button = 0, 54, tut1_sel_dummy_tga, NULL, tut1_selector_pcx, tut1_select_item, NULL, NULL;
	button = 0, 72, tut1_sel_dummy_tga, NULL, tut1_selector_pcx, tut1_select_item, NULL, NULL;
	pos_x = 20;
	pos_y = 40;
	layer = 2;
	//use this flag for blending
	//flags = transparent;
}

TEXT input_txt
{
	font = menu_font;
	pos_x = 23;
	pos_y = 22;
	layer = 3;
	strings = 1;
	string = choosen_str;
	flags = visible;
}

TEXT choice_txt
{
	font = menu_font;
	pos_x = 23;
	pos_y = 42;
	layer = 3;
	strings = 1;
	string = choice_str;
	//use this flag for blending
	//flags = transparent;
}

function main()
{
	level_load(main_wmb);
	
	str_cpy(choosen_str, "Smith");
	
	mouse_map = mousemap;
	mouse_mode = 2;
	
	while(1)
	{ 
   	MOUSE_POS.X = POINTER.X;
      MOUSE_POS.Y = POINTER.Y;
      wait(1);
   }
}

function swap_choice_panel()
{
	// show / hide
	choice_pan.visible = (choice_pan.visible == off);
	choice_txt.visible = (choice_txt.visible == off);
	
	// roll down / up
	/*if(choice_pan.visible == off)
	{
		choice_pan.scale_y = 0.1;
		choice_pan.visible = on;
		while(choice_pan.scale_y < 0.9)
		{
			choice_pan.scale_y += 0.1 * time;
			wait(1);
		}
		choice_pan.scale_y = 1;
		choice_txt.visible = on;
	}
	else
	{
		choice_txt.visible = off;
		while(choice_pan.scale_y > 0.1)
		{
			choice_pan.scale_y -= 0.1 * time;
			wait(1);
		}
		choice_pan.visible = off;
	}*/
	
	// blend in / out
	/*if(choice_pan.visible == off)
	{
		choice_pan.alpha = 0;
		choice_txt.alpha = 0;
		choice_pan.visible = on;
		choice_txt.visible = on;
		while(choice_pan.alpha < 100)
		{
			choice_pan.alpha += 5 * time;
			choice_txt.alpha += 5 * time;
			wait(1);
		}
		choice_pan.alpha = 100;
		choice_txt.alpha = 100;		
	}
	else
	{
		while(choice_pan.alpha > 0)
		{
			choice_pan.alpha -= 5 * time;
			choice_txt.alpha -= 5 * time;
			wait(1);
		}
		choice_pan.alpha = 0;
		choice_txt.alpha = 0;
		choice_pan.visible = off;
		choice_txt.visible = off;
	}*/
}

function tut1_select_item(button_number, panel)
{
	if(button_number == 1)
	{
		str_cpy(choosen_str, "Smith");
	}
	if(button_number == 2)
	{
		str_cpy(choosen_str, "Wesson");
	}
	if(button_number == 3)
	{
		str_cpy(choosen_str, "Heckler");
	}
	if(button_number == 4)
	{
		str_cpy(choosen_str, "Koch");
	}
	if(button_number == 5)
	{
		str_cpy(choosen_str, "Colt");
	}
	swap_choice_panel();
}